*==============================================================================*
* TTULO DE LA SINTAXIS:*
* Sintaxis de Tabulados 
* OPERACIN ESTADSTICA:*
* Egresos Hospitalarios, Ao 2017(EEH - 2017)*
* UNIDAD TCNICA RESPONSABLE:*
* Unidad de Gestin de Estadsticas Sociodemogrficas en base a Registros Administrativos*
* Direccin Estadsticas Sociodemogrficas (DIES) *
* ENTIDAD EJECUTORA:*
* Instituto Nacional de Estadstica y Censos (INEC) *
*==============================================================================*
* Fecha ltima modificacin:   mayo de 2018*
*==============================================================================*
* Modificado por:* 
* Equipo tcnico**
* Unidad de Gestin de Estadsticas Sociodemogrficas en base a Registros Administrativos (GESRA) *
* Instituto Nacional de Estadstica y Censos (INEC)*
*==============================================================================*
* Revisado por: *
* Jefe de la unidad*
* Responsable de la Unidad de Gestin de Estadsticas Sociodemogrficas en base a Registros Administrativos (GESRA) * *
* Instituto Nacional de Estadstica y Censos (INEC)*
*==============================================================================*
*==============================================================================*
* Descripcin:
* 1. Correr la programacin en spss.
* 2. La presente sintaxis est diseada para generar y crear las variables necesarias para la elaboracin de los cuadros estadsticos de Egresos.
* Correpondiente al anuario de Camas y Egresos Hospitalarios.
*==============================================================================*
*Sintaxis de Tabulados Egresos Hospitalarios, Ao 2017 (EEH - 2017)*
*==============================================================================*

*Cuadro 3.1.8.

*Egresos hospitalarios por condicin al egreso, das y promedio de estada, tasas de mortalidad hospitalaria, segn clase y entidad.

GET
  FILE=' D:\EGRESOS Y CAMAS\BASES EGRESOS\egresos_hospitalarios_2017.sav'.

*Crear variables  de trabajo.

compute t0 = 1.
compute t1 = 1.

*Definicin de variables para la condicin de egreso.

if con_egrpa = 1 altas = 1.
if con_egrpa = 1 daltas = dia_estad.
if con_egrpa = 2 men48 = 1.
if con_egrpa = 2 dmen48 = dia_estad.
if con_egrpa = 3 mas48 = 1.
if con_egrpa = 3 dmas48 = dia_estad.
if con_egrpa = 2 or con_egrpa = 3 bajas = 1.
if con_egrpa = 2 or con_egrpa = 3 dbajas = dia_estad.
EXECUTE.

* Para agrupar las sectores con entidades.

STRING wclase1 (A1).
COMPUTE wclase1 = '1'.
COMPUTE wclase1 = '9'.

if clase = 11 wclase1 = '1'.
if (clase = 3 or clase = 4  or clase = 5  or clase = 6  or clase = 7  or clase = 8  or clase = 9  or clase = 10)  wclase1 = '2'.
if clase = 2 wclase1 = '3'.
if clase = 1 wclase1 = '4'.
if clase = 12 wclase1 = '5'.
if clase = 13 or clase = 14  or clase = 15  or clase = 16  or clase = 17 wclase1 = '6'.

VARIABLE LABELS 
t0   'Total Egresos' 
t1   'Total egreso tipo'
/daltas 'Altas'
/dbajas 'dias de estada Fallecidos'
/dmen48 'Menos de 48 horas'
/dmas48 '48 Horas y ms'
/altas  'Egresos'
/bajas 'Fallecidos'
/men48  'Egresos menos de 48 horas'
/mas48  'Egresos 48 horas y ms'.

VALUE LABELS 
t0 1	' '
/t1 1      ' '
/wclase1
'1'	'Hospital de especialidades'
'2'	'Hospital especializado'
'3'	'Hospital general'
'4'	'Hospital bsico'
'5'	'Clnica General'
'6'	'Clnicas Especializadas'
'9'	'ERRADO'.


CTABLES
  /VLABELS VARIABLES=t0 wclase1 entidad t1 dia_estad altas daltas bajas men48 mas48 dbajas 
    DISPLAY=BOTH
  /TABLE t0 [C] + wclase1 [C] > entidad [C] BY t1 [C][COUNT F40.0] + dia_estad [SUM, MEAN] + altas 
    [C][COUNT F40.0] + daltas [S][SUM, MEAN] + bajas [C][COUNT F40.0] + men48 [C][COUNT F40.0] + mas48 
    [C][COUNT F40.0] + dbajas [S][SUM, MEAN]
  /CATEGORIES VARIABLES=t0 entidad t1 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=altas bajas men48 mas48 ORDER=A KEY=VALUE EMPTY=EXCLUDE.


*Cuadro 3.1.9.
*Egresos hospitalarios por condicin al egreso y sexo, Tasa de letalidad hospitalaria, segn grupos de causa de morbilidad
Lista de Agrupamiento de 298 causas - Cie - 10.

GET FILE=' D:\EGRESOS Y CAMAS\BASES EGRESOS\egresos_hospitalarios_2017.sav'.
filter off.
use all.
*Crear variables  de trabajo.
compute t = 1.
compute t1 = 1.
compute t2 = 1.

*Condicin del Egreso recodificada.

  string con_egrpa1 (A2).
  if (con_egrpa = 1)  con_egrpa1 = '01'.
  if (con_egrpa = 2 or con_egrpa = 3)  con_egrpa1 = "02".
string saltas (A1).
string sfall (A1).
string tfall (A1).
string taltas (A1).
if (con_egrpa = 1) saltas ='1'.
if (con_egrpa = 1) sfall ='1'.
if (con_egrpa = 1) tfall ='1'.
if (con_egrpa = 1) taltas ='1'.

VARIABLE LABELS
t	'Total'
t1	'Total Repblica'
t2	'Total '.

VALUE LABELS 
/con_egrpa1
'01'	'Altas'
'02'	'Fallecidos'
/t 	1	' '
/t2	1	' '
/taltas '1' 'Altas '
/tfall  '1' 'Fallecidos '
/saltas
'1'	'Sexo'
/sfall
'1'	'Sexo'.

TABLES
/TABLE	(t1+cau298rx) by (t+sexo+ (con_egrpa1 > (t2+sexo)) )
/TITLES 'Cuadro N. 9'
	'Egresos hospitalarios por condicin al egreso y exo, Tasa de letalidad hospitalaria, segn grupos de causa de morbilidad'
            'Lista de Agrupamiento de 298 Causas - CIE - 10'
/CORNER .
EXECUTE.

*Cuadro 3.1.10.
*Egresos hospitalarios por provincia de residencia habitual, segn grupos de causa de morbilidad
Lista de Agrupamiento de 298 causas - CIE - 10.

GET FILE=' D:\EGRESOS Y CAMAS\BASES EGRESOS\egresos_hospitalarios_2017.sav'.

filter off.
use all.
*Crear variables  de trabajo.
compute t = 1.
compute t1 = 1.

VARIABLE LABELS 
t	'Total Egresos'
t1	'Total Repblica'.

VALUE LABELS 
t 	1	' '
/t1  	1	' '.

TABLES
/TABLE	(t1+cau298rx) by (t+prov_res)
/TITLES 'Cuadro N. 10'
	'Egresos hospitalarios por provincia de residencia habitual, segn grupos de causa de morbilidad'
            ' Lista de Agrupamiento de 298 Causas - CIE - 10'
/CORNER .
EXECUTE.




